<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../classi/ArticoliDalBlog.php";
    
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_ADD_SLASHES);
        $occorrenza = new ArticoliDalBlog($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_ADD_SLASHES);
        $occorrenza = new ArticoliDalBlog($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $occorrenza->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setEtichettaPulsanteALtriArticoli(filter_input(INPUT_POST,"etichettaPulsanteALtriArticoli"));
            $occorrenza->setNumeroArticoli(filter_input(INPUT_POST,"numeroArticoli"));
            $occorrenza->setDimensioneDivSingoloArticolo(filter_input(INPUT_POST,"dimensioneDivSingoloArticolo",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setCategoria(filter_input(INPUT_POST,"categoria",FILTER_SANITIZE_NUMBER_INT));
            $occorrenza->setCategorieIndicate(filter_input(INPUT_POST,"categorieIndicate",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setEscludiCategoria(filter_input(INPUT_POST,"escludiCategoria"));
            $occorrenza->setLingua(filter_input(INPUT_POST,"lingua",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setMostraTitoloComponente(filter_input(INPUT_POST,"mostraTitoloComponente"));
            $occorrenza->setMostraTesto(filter_input(INPUT_POST,"mostraTesto",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setMostraImmagini(filter_input(INPUT_POST,"mostraImmagini",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->crea();
            header("Location: ../creaArticoliDalBlog.php?id={$occorrenza->getId()}&status=200");
            break;
        case 'modifica':
            $occorrenza->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setEtichettaPulsanteALtriArticoli(filter_input(INPUT_POST,"etichettaPulsanteALtriArticoli"));
            $occorrenza->setNumeroArticoli(filter_input(INPUT_POST,"numeroArticoli"));
            $occorrenza->setDimensioneDivSingoloArticolo(filter_input(INPUT_POST,"dimensioneDivSingoloArticolo",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setCategoria(filter_input(INPUT_POST,"categoria",FILTER_SANITIZE_NUMBER_INT));
            $occorrenza->setCategorieIndicate(filter_input(INPUT_POST,"categorieIndicate",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setEscludiCategoria(filter_input(INPUT_POST,"escludiCategoria"));
            $occorrenza->setLingua(filter_input(INPUT_POST,"lingua",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setMostraTitoloComponente(filter_input(INPUT_POST,"mostraTitoloComponente"));
            $occorrenza->setMostraTesto(filter_input(INPUT_POST,"mostraTesto",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->setMostraImmagini(filter_input(INPUT_POST,"mostraImmagini",FILTER_SANITIZE_ADD_SLASHES));
            $occorrenza->modifica();
            header("Location: ../creaArticoliDalBlog.php?id={$occorrenza->getId()}&status=250");
            break;
        case 'elimina':
            $occorrenza->elimina();
            echo "ok";
            break;
        case 'duplica':
            $occorrenza->caricaDatiDalDatabase();
            $idNuovaForm = $occorrenza->duplica();
            header("Location: ../creaArticoliDalBlog.php?id={$idNuovaForm}&status=260");
            break;
    }
